
import time
from django.conf import settings
from django.contrib.auth import logout
from django.shortcuts import redirect

class SessionTimeoutMiddleware:
    def __init__(self,get_response):
        self.get_response=get_response
        self.timeout=settings.SESSION_IDLE_TIMEOUT

    def __call__(self,request):
        if request.user.is_authenticated:
            now=int(time.time())
            last=request.session.get('last_activity',now)
            if now-last>self.timeout:
                logout(request)
                return redirect('login')
            request.session['last_activity']=now
        return self.get_response(request)
